--
-- DynamicHeaderSpeedSetting
--
-- @autor   nilBrain @VertexDezign
-- @date    26/01/2023
-- @node register setting for Dynamic Header Speed
-- Copyright (C) nilBrain, Confidential, All Rights Reserved.

DynamicHeaderSpeedSetting = {};
local DynamicHeaderSpeedSetting_mt = Class(DynamicHeaderSpeedSetting)


function DynamicHeaderSpeedSetting.new(customMt)
	local self = setmetatable({}, customMt or DynamicHeaderSpeedSetting_mt);

    self.settings = {"0.5", "0.6", "0.7", "0.8", "0.9", "1.0", "1.1", "1.2", "1.3", "1.4", "1.5"};
    self.speedIndex = 6;

    return self;
end;

function DynamicHeaderSpeedSetting:getSpeedIndex()
    return self.speedIndex;
end;

function DynamicHeaderSpeedSetting:getValidSpeedIndex(value)
    local index = value;

    if MathUtil.getIsOutOfBounds(value, 1, #self.settings) then
        if value > #self.settings then
            index = 1;
        else
            index = #self.settings;
        end;
    end;

    return index;
end;


function DynamicHeaderSpeedSetting:getIndexFromSpeed(speedScale)
    for index, speed in pairs(self.settings) do
        if speed == tostring(speedScale) then
            return index;
        end;
    end;

    return self.speedIndex;
end;

function DynamicHeaderSpeedSetting:getSpeedFromIndex(index)
    if index ~= nil and self.settings[index] ~= nil then
        return self.settings[index];
    end;
    return self.settings[6]
end;

function DynamicHeaderSpeedSetting.getHeader(vehicle)
    if vehicle ~= nil then
        if vehicle.spec_dynamicHeaderSpeed ~= nil then
            return vehicle;
        else

            if vehicle.getAttachedImplements ~= nil then
                for _, implement in ipairs(vehicle:getAttachedImplements()) do
                    if implement.object.spec_dynamicHeaderSpeed ~= nil then
                        return implement.object;
                    end;
                end;
            end;

        end;
    end;
end;

g_dynamicHeaderSpeedSetting = DynamicHeaderSpeedSetting.new();