-- Register SeedbedReconsolidation Specialization
-- Author: RedFoxModding
-- Version: 1.1.0.0


--Changelog: 
--1.0.0.0 initial implementation for FS22
--1.1.0.0 fix for patch 1.4

RegisterSpec = {}
RegisterSpec.currentModDirectory = g_currentModDirectory

function RegisterSpec:addSpec()
	if g_specializationManager:getSpecializationByName("SeedbedReconsolidation") == nil then
		g_specializationManager:addSpecialization("SeedbedReconsolidation", "SeedbedReconsolidation", Utils.getFilename("seedbedReconsolidation.lua", RegisterSpec.currentModDirectory), nil)

		for typeName, typeEntry in pairs(g_vehicleTypeManager.types) do
			if not SpecializationUtil.hasSpecialization(SeedbedReconsolidation, typeEntry.specializations) and SpecializationUtil.hasSpecialization(SowingMachine, typeEntry.specializations) then
				g_vehicleTypeManager:addSpecialization(typeName, "SeedbedReconsolidation")
				--print("SeedbedReconsolidation: Added Specialization for "..tostring(typeName))
			else
				--print("SeedbedReconsolidation: Not Added for "..tostring(typeName))
			end
		end
	end
end

TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, RegisterSpec.addSpec)