-- Script to inject the real Mulcher specialization in every vehicle
-- Authors: SMI Modding Team (Nicola)
-- Game version: Farming Simulator 25
-- Version: 1.0.0.0 - 24.11.2024	
local modName = g_currentModName or "unknown"

local function initSpecialization(manager)
    if manager.typeName == "vehicle" then
        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
			if typeEntry ~= nil and typeName ~= "locomotive" and typeName ~= "trainTrailer" and typeName ~= "trainTimberTrailer" then 
				if SpecializationUtil.hasSpecialization(Mulcher, typeEntry.specializations) then
					g_vehicleTypeManager:addSpecialization(typeName, modName .. ".realMulcher")
				end
            end
        end
    end
end

local function init()
    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, initSpecialization)
end

init()