-- readust.lua
-- REA Dust Aggregator für FS25
-- Berechnet pro Fahrzeug Staub- und Matsch-Intensität auf Basis von Schlupf und Bodenfeuchte.

READust = {}
READust.modName = g_currentModName or "REAplus"
READust.modDir  = g_currentModDirectory or ""

-- Konfiguration
READust.CONFIG = {
    dustScale = 1.0,   -- Einfluss von Schlupf auf Staub
    mudScale  = 1.0    -- Einfluss von Schlupf + Nässe auf Matsch
}

local function rdxPrint(msg)
    print(string.format("READust: %s", tostring(msg)))
end

local function clamp(v, mn, mx)
    if v < mn then return mn end
    if v > mx then return mx end
    return v
end

--------------------------------------------------------------------
-- ModEventListener
--------------------------------------------------------------------
function READust:loadMap(name)
    rdxPrint("READust geladen (Fahrzeug-Intensitäten aktiv).")
end

function READust:deleteMap()
end

function READust:keyEvent(unicode, sym, modifier, isDown)
end

function READust:mouseEvent(posX, posY, isDown, isUp, button)
end

--------------------------------------------------------------------
-- Update: Staub-/Matsch-Intensität pro Fahrzeug berechnen
--------------------------------------------------------------------
function READust:update(dt)
    if g_currentMission == nil or g_currentMission.vehicles == nil then
        return
    end

    local scale = 1.0
    if REALFARM ~= nil and REALFARM.getScale ~= nil then
        scale = REALFARM:getScale()
    end

    for _, vehicle in ipairs(g_currentMission.vehicles) do
        if vehicle ~= nil then
            local specWheels = vehicle.spec_wheels
            if specWheels ~= nil and specWheels.wheels ~= nil then
                local maxDust = 0
                local maxMud  = 0

                for _, wheel in ipairs(specWheels.wheels) do
                    -- Schlupf (ABS-Wert)
                    local slip = math.abs(wheel.lastSlip or 0)

                    -- Bodenfeuchte / Nässe-Faktor:
                    -- Falls REAwheels bereits REA_wetFactor am Rad setzt, nutzen wir den.
                    local wet = wheel.REA_wetFactor or 0

                    -- Basiswerte
                    local dustAmount = slip * (1.0 - wet) * scale
                    local mudAmount  = slip * wet * scale

                    -- Skaliert und begrenzt
                    local dustRate = clamp(dustAmount * READust.CONFIG.dustScale * 100, 0, 100)
                    local mudRate  = clamp(mudAmount  * READust.CONFIG.mudScale  * 120, 0, 120)

                    if dustRate > maxDust then
                        maxDust = dustRate
                    end
                    if mudRate > maxMud then
                        maxMud = mudRate
                    end
                end

                -- Pro Fahrzeug Intensitäten setzen
                vehicle.REA_dustIntensity = maxDust
                vehicle.REA_mudIntensity  = maxMud
            end
        end
    end
end

--------------------------------------------------------------------
-- Draw (optional Debug – aktuell leer)
--------------------------------------------------------------------
function READust:draw()
    -- Hier könnte später ein Debug-HUD hin:
    -- z.B. Anzeige von REA_dustIntensity / REA_mudIntensity.
end

addModEventListener(READust)
