-- rea_dust_wheels.lua
-- Liefert Feuchte- und Schlupfwerte an READust/REA wheels

READustWheels = {}
local function dPrint(msg) print(("READustWheels: %s"):format(tostring(msg))) end

function READustWheels.prerequisitesPresent(specializations)
    return true
end

function READustWheels.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", READustWheels)
end

function READustWheels:onUpdate(dt)
    local wheels = self.spec_wheels and self.spec_wheels.wheels
    if wheels == nil then return end

    for _, w in ipairs(wheels) do
        if w.lastSlip then
            -- Giants FS25 TerrainWetness → realer Nässewert
            w.REA_wetFactor = w.wetnessMultiplier or 0
        end
    end
end
