-- Filename: CameraZoom.lua
-- Author: SMI Modding Team (Nicola)
-- Date: 06/11/2024
-- version: 1.0.0.0

CameraZoom = {}

CameraZoom.ORIGINAL_FOV = -1
CameraZoom.fov_multiplier = 1
CameraZoom.SENSITIVITY = 3
CameraZoom.y_offset = 0
CameraZoom.Y_STEP_SIZE = 0.2

function CameraZoom:update(dt)
    local player = g_localPlayer

    if g_gui == nil then
        return 
    elseif g_gui.currentGuiName ~= "" then
        return end

    local camera = getCamera()

    if CameraZoom.ORIGINAL_FOV == -1 then
        CameraZoom.ORIGINAL_FOV = getFovY(camera)
    end

    if player.isControlled and player.camera.thirdPersonCamera ~= camera then
        if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) and Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) then
            CameraZoom.fov_multiplier = math.min(2, CameraZoom.fov_multiplier + CameraZoom.SENSITIVITY * dt / 1000)
            setFovY(camera, CameraZoom.ORIGINAL_FOV * CameraZoom.fov_multiplier);

        elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) and CameraZoom.y_offset > -0.5 then
            CameraZoom.y_offset = CameraZoom.y_offset - CameraZoom.Y_STEP_SIZE 

        elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) and Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) then
            CameraZoom.fov_multiplier = math.max(0.067, CameraZoom.fov_multiplier - CameraZoom.SENSITIVITY * dt / 1000);
            setFovY(camera, CameraZoom.ORIGINAL_FOV * CameraZoom.fov_multiplier);

        elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) and CameraZoom.y_offset < 10 then
            CameraZoom.y_offset = CameraZoom.y_offset + CameraZoom.Y_STEP_SIZE 

        elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
            setFovY(camera, CameraZoom.ORIGINAL_FOV)
            CameraZoom.y_offset = 0
            CameraZoom.fov_multiplier = 1
        end
    end
end

function CameraZoom.onUpdateCameraPosition()
    local xf,yf,zf = g_localPlayer.camera:getFocusPosition()
    g_localPlayer.camera:setFocusPosition(xf, yf + CameraZoom.y_offset, zf)
end

PlayerCamera.updatePosition = Utils.appendedFunction(PlayerCamera.updatePosition, CameraZoom.onUpdateCameraPosition)

addModEventListener(CameraZoom)